const express = require("express");
const router = express.Router();
const studentController = require("../controllers/studentController");
const { auth, authorize } = require("../middleware/auth");
const checkSubscription = require("../middleware/checkSubscription");

const multer = require("multer");
const upload = multer({ storage: multer.memoryStorage() });

// Define middleware chains for different access levels
const viewAccess = [auth, checkSubscription, authorize("admin", "staff")];
const manageAccess = [auth, checkSubscription, authorize("admin")];

// Routes accessible by both Admin and Staff
router.get("/search", ...viewAccess, studentController.searchStudents);
router.get("/", ...viewAccess, studentController.getAllStudents);
router.get("/:id", ...viewAccess, studentController.getStudentById);
router.get(
  "/report/pdf",
  ...viewAccess,
  studentController.generateStudentListPdf
);

// Routes restricted to Admin only
router.post("/", ...manageAccess, studentController.createStudent);
router.put("/:id", ...manageAccess, studentController.updateStudent);
router.delete("/:id", ...manageAccess, studentController.deleteStudent);


router.post("/students/bulk-upload",...manageAccess,upload.single("file"),studentController.bulkCreateStudents);


module.exports = router;
