// routes/planAndSubscriptionRoutes.js
const express = require('express');
const router = express.Router();
const planController = require('../controllers/planController');
const subscriptionController = require('../controllers/subscriptionController');
const { auth, authorize } = require('../middleware/auth');
const checkSubscription = require('../middleware/checkSubscription'); // Import

// --- Plan Management (Super Admin Only) ---
const superAdminAccess = [auth, authorize('super_admin')];

router.post('/plans', ...superAdminAccess, planController.createPlan);
router.get('/plans', ...superAdminAccess, planController.getAllPlans);
router.get('/plans/:id', ...superAdminAccess, planController.getPlan);
router.put('/plans/:id', ...superAdminAccess, planController.updatePlan);
router.delete('/plans/:id', ...superAdminAccess, planController.deletePlan);


// --- Subscription Management ---

// (Super Admin) Create a subscription for an institution
router.post('/subscriptions', ...superAdminAccess, subscriptionController.createSubscription);
// (Super Admin) Get all subscriptions for a specific institution
router.get('/subscriptions/institution/:id', ...superAdminAccess, subscriptionController.getSubscriptionsForInstitution);
// (Super Admin) Update a specific subscription
router.put('/subscriptions/:id', ...superAdminAccess, subscriptionController.updateSubscription);

router.get('/subscriptions/my-active', auth, authorize('admin'), checkSubscription, subscriptionController.getMyActiveSubscription);

module.exports = router;