const express = require('express');
const router = express.Router();
const gradeController = require('../controllers/gradeController');
const { auth, authorize } = require('../middleware/auth');
const checkSubscription = require('../middleware/checkSubscription');

// Define middleware chains for different access levels
const viewAccess = [auth, checkSubscription, authorize('admin', 'staff')];
const manageAccess = [auth, checkSubscription, authorize('admin')];

router.get('/', ...viewAccess, gradeController.getAllGrades);
router.post('/', ...manageAccess, gradeController.createGrade);
router.put('/:id', ...manageAccess, gradeController.updateGrade);
router.delete('/:id', ...manageAccess, gradeController.deleteGrade);

module.exports = router;