const express = require('express');
const router = express.Router();
const attendanceController = require('../controllers/attendanceController');
const { auth, authorize } = require('../middleware/auth');
const checkSubscription = require('../middleware/checkSubscription');

// Define the middleware chain for regular users
const userAccess = [auth, authorize('admin', 'staff'), checkSubscription];

router.post('/qr', ...userAccess, attendanceController.logAttendanceByQr);
router.post('/manual', ...userAccess, attendanceController.logAttendanceManually);
router.get('/history', ...userAccess, attendanceController.getHistory);
router.get('/summary/by-grade', ...userAccess, attendanceController.getTodaySummaryByGrade);
router.get('/report/pdf', ...userAccess, attendanceController.generatePdfReport);

module.exports = router;